/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public final General general = new General();

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("General");
        this.general.emcLinkMaxOutput = builder.comment("Max EMC which Personal/Refined/Compressed Refined Link Blocks can remove from personal EMC (in one operation) when extracting items. Setting this to 0 disables extraction of any item from these blocks.").defineInRange("emc_link_max_output", 2000000000L, 0L, Long.MAX_VALUE);
        this.general.enableStoneTableWhitelist = builder.comment("If false, ignore the Stone Table whitelist, which is the 'extendedexchange:stone_table_whitelist' item tag. If true, only items in that tag can be placed in the Stone Table.").define("enable_stone_table_whitelist", false);
        this.general.finalStarCopiesAnyItem = builder.comment("If false, the Final Star can only copy items that have an EMC value.").define("final_star_copies_any_item", true);
        this.general.finalStarCopiesNBT = builder.comment("If false, items copied by the Final Star will have no NBT, unless they are in the 'projecte:nbt_whitelist' item tag.").define("final_star_copies_nbt", false);
        this.general.finalStarUpdateInterval = builder.comment("Update interval in ticks for the Final Star when in a Pedestal. Setting this to 0 prevents any item copying (making the Final Star useless...)").defineInRange("final_star_update_interval", 20, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    public static class General {
        public ForgeConfigSpec.LongValue emcLinkMaxOutput;
        public ForgeConfigSpec.BooleanValue enableStoneTableWhitelist;
        public ForgeConfigSpec.BooleanValue finalStarCopiesAnyItem;
        public ForgeConfigSpec.BooleanValue finalStarCopiesNBT;
        public ForgeConfigSpec.IntValue finalStarUpdateInterval;
    }
}

